<?php
/*--------------------------------------------------------------
   DeleteWidget.php 2021-06-03
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Action;

use Exception;
use Gambio\Admin\Modules\Statistics\App\Overview\Service;
use Gambio\Core\Application\Http\AbstractAction;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

/**
 * @codeCoverageIgnore
 */
class DeleteWidget extends AbstractAction
{
    /**
     * @var Service
     */
    private $service;
    
    
    /**
     * Constructor.
     */
    public function __construct(Service $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        try {
            $this->service->deleteWidget((int)$request->getAttribute("id"));
        } catch (Exception $exception) {
            return $response->withStatus(400)->write($exception->getMessage());
        }
        
        return $response->withStatus(200);
    }
}